package robocup.lab.intelligent;

import atan.model.AbstractTeam;
import atan.model.ControllerPlayer;

/**
 * The Class IntelligentTeam.
 */
public class IntelligentTeam extends AbstractTeam {

	/**
	 * Instantiates a new intelligent team.
	 *
	 * @param teamName the team name
	 * @param port the port
	 * @param hostname the hostname
	 */
	public IntelligentTeam(String teamName, int port, String hostname) {
		super(teamName, port, hostname);
	}

	/* (non-Javadoc)
	 * @see atan.model.AbstractTeam#size()
	 */
	@Override
	public int size() {
		return 11;
	}

	/* (non-Javadoc)
	 * @see atan.model.AbstractTeam#getNewController(int)
	 */
	@Override
	public ControllerPlayer getNewController(int number) {
		if (number == 5)
			return new IntelligentController();
		else
			return new IntelligentStaticController();
	}

}
