package robocup.lab.opponent;

import java.util.Random;

import atan.model.ActionsPlayer;
import atan.model.ControllerPlayer;
import atan.model.enums.Errors;
import atan.model.enums.Flag;
import atan.model.enums.Line;
import atan.model.enums.Ok;
import atan.model.enums.PlayMode;
import atan.model.enums.RefereeMessage;
import atan.model.enums.ViewAngle;
import atan.model.enums.ViewQuality;
import atan.model.enums.Warning;

/**
 * The Class OpponentController.
 */
public class OpponentController implements ControllerPlayer {

    /**
     * The player.
     */
    private ActionsPlayer	player;
    
    /**
     * The random.
     */
    private Random			random = null;
    
    /**
     * The count.
     */
    private static int 	 	count = 0;
    
    /**
     * Instantiates a new opponent controller.
     */
    public OpponentController() {
    	count++;
    	random = new Random(System.currentTimeMillis() + count);
    }
    
	/* (non-Javadoc)
	 * @see atan.model.ControllerPlayer#getPlayer()
	 */
	@Override
	public ActionsPlayer getPlayer() {
		return player;
	}

	/* (non-Javadoc)
	 * @see atan.model.ControllerPlayer#getType()
	 */
	@Override
	public String getType() {
		// TODO Auto-generated method stub
		return null;
	}

	/* (non-Javadoc)
	 * @see atan.model.ControllerPlayer#infoHearError(atan.model.enums.Errors)
	 */
	@Override
	public void infoHearError(Errors error) {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see atan.model.ControllerPlayer#infoHearOk(atan.model.enums.Ok)
	 */
	@Override
	public void infoHearOk(Ok ok) {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see atan.model.ControllerPlayer#infoHearPlayMode(atan.model.enums.PlayMode)
	 */
	@Override
	public void infoHearPlayMode(PlayMode playMode) {
		// TODO Auto-generated method stub
//	       if (playMode == PlayMode.BEFORE_KICK_OFF) {
//	    	   this.getPlayer().move(randomXPosition(), randomYPosition());         
//	       }
        if (playMode == PlayMode.BEFORE_KICK_OFF) {
            switch (this.getPlayer().getNumber()) {
                case 1 :
                    this.getPlayer().move(-30, -20);
                    break;
                case 2 :
                    this.getPlayer().move(-30, -10);
                    break;
                case 3 :
                    this.getPlayer().move(-30, 0);
                    break;
                case 4 :
                    this.getPlayer().move(-30, 10);
                    break;
                case 5 :
                    this.getPlayer().move(-30, 20);
                    break;
                case 6 :
                    break;
                case 7 :
                    this.getPlayer().move(-20, -5);
                    break;
                case 8 :
                    this.getPlayer().move(-20, 0);
                    break;
                case 9 :
                    this.getPlayer().move(-20, 5);
                    break;
                case 10 :
                    this.getPlayer().move(-10, -2);
                    break;
                case 11 :
                    this.getPlayer().move(-10, 2);
                    break;
                default :
                    throw new Error("number must be initialized before move");
            }
        }
	}

	/* (non-Javadoc)
	 * @see atan.model.ControllerPlayer#infoHearPlayer(double, java.lang.String)
	 */
	@Override
	public void infoHearPlayer(double direction, String message) {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see atan.model.ControllerPlayer#infoHearReferee(atan.model.enums.RefereeMessage)
	 */
	@Override
	public void infoHearReferee(RefereeMessage refereeMessage) {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see atan.model.ControllerPlayer#infoHearWarning(atan.model.enums.Warning)
	 */
	@Override
	public void infoHearWarning(Warning warning) {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see atan.model.ControllerPlayer#infoSeeBall(double, double, double, double, double, double)
	 */
	@Override
	public void infoSeeBall(double distance, double direction,
			double distChange, double dirChange, double bodyFacingDirection,
			double headFacingDirection) {
		// TODO Auto-generated method stub
	}

	/* (non-Javadoc)
	 * @see atan.model.ControllerPlayer#infoSeeFlagCenter(atan.model.enums.Flag, double, double, double, double, double, double)
	 */
	@Override
	public void infoSeeFlagCenter(Flag flag, double distance, double direction,
			double distChange, double dirChange, double bodyFacingDirection,
			double headFacingDirection) {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see atan.model.ControllerPlayer#infoSeeFlagCornerOther(atan.model.enums.Flag, double, double, double, double, double, double)
	 */
	@Override
	public void infoSeeFlagCornerOther(Flag flag, double distance,
			double direction, double distChange, double dirChange,
			double bodyFacingDirection, double headFacingDirection) {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see atan.model.ControllerPlayer#infoSeeFlagCornerOwn(atan.model.enums.Flag, double, double, double, double, double, double)
	 */
	@Override
	public void infoSeeFlagCornerOwn(Flag flag, double distance,
			double direction, double distChange, double dirChange,
			double bodyFacingDirection, double headFacingDirection) {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see atan.model.ControllerPlayer#infoSeeFlagGoalOther(atan.model.enums.Flag, double, double, double, double, double, double)
	 */
	@Override
	public void infoSeeFlagGoalOther(Flag flag, double distance,
			double direction, double distChange, double dirChange,
			double bodyFacingDirection, double headFacingDirection) {
		// TODO Auto-generated method stub
	}

	/* (non-Javadoc)
	 * @see atan.model.ControllerPlayer#infoSeeFlagGoalOwn(atan.model.enums.Flag, double, double, double, double, double, double)
	 */
	@Override
	public void infoSeeFlagGoalOwn(Flag flag, double distance,
			double direction, double distChange, double dirChange,
			double bodyFacingDirection, double headFacingDirection) {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see atan.model.ControllerPlayer#infoSeeFlagLeft(atan.model.enums.Flag, double, double, double, double, double, double)
	 */
	@Override
	public void infoSeeFlagLeft(Flag flag, double distance, double direction,
			double distChange, double dirChange, double bodyFacingDirection,
			double headFacingDirection) {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see atan.model.ControllerPlayer#infoSeeFlagOther(atan.model.enums.Flag, double, double, double, double, double, double)
	 */
	@Override
	public void infoSeeFlagOther(Flag flag, double distance, double direction,
			double distChange, double dirChange, double bodyFacingDirection,
			double headFacingDirection) {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see atan.model.ControllerPlayer#infoSeeFlagOwn(atan.model.enums.Flag, double, double, double, double, double, double)
	 */
	@Override
	public void infoSeeFlagOwn(Flag flag, double distance, double direction,
			double distChange, double dirChange, double bodyFacingDirection,
			double headFacingDirection) {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see atan.model.ControllerPlayer#infoSeeFlagPenaltyOther(atan.model.enums.Flag, double, double, double, double, double, double)
	 */
	@Override
	public void infoSeeFlagPenaltyOther(Flag flag, double distance,
			double direction, double distChange, double dirChange,
			double bodyFacingDirection, double headFacingDirection) {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see atan.model.ControllerPlayer#infoSeeFlagPenaltyOwn(atan.model.enums.Flag, double, double, double, double, double, double)
	 */
	@Override
	public void infoSeeFlagPenaltyOwn(Flag flag, double distance,
			double direction, double distChange, double dirChange,
			double bodyFacingDirection, double headFacingDirection) {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see atan.model.ControllerPlayer#infoSeeFlagRight(atan.model.enums.Flag, double, double, double, double, double, double)
	 */
	@Override
	public void infoSeeFlagRight(Flag flag, double distance, double direction,
			double distChange, double dirChange, double bodyFacingDirection,
			double headFacingDirection) {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see atan.model.ControllerPlayer#infoSeeLine(atan.model.enums.Line, double, double, double, double, double, double)
	 */
	@Override
	public void infoSeeLine(Line line, double distance, double direction,
			double distChange, double dirChange, double bodyFacingDirection,
			double headFacingDirection) {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see atan.model.ControllerPlayer#infoSeePlayerOther(int, boolean, double, double, double, double, double, double)
	 */
	@Override
	public void infoSeePlayerOther(int number, boolean goalie, double distance,
			double direction, double distChange, double dirChange,
			double bodyFacingDirection, double headFacingDirection) {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see atan.model.ControllerPlayer#infoSeePlayerOwn(int, boolean, double, double, double, double, double, double)
	 */
	@Override
	public void infoSeePlayerOwn(int number, boolean goalie, double distance,
			double direction, double distChange, double dirChange,
			double bodyFacingDirection, double headFacingDirection) {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see atan.model.ControllerPlayer#infoSenseBody(atan.model.enums.ViewQuality, atan.model.enums.ViewAngle, double, double, double, double, double, double, int, int, int, int, int, int, int, int)
	 */
	@Override
	public void infoSenseBody(ViewQuality viewQuality, ViewAngle viewAngle,
			double stamina, double unknown, double effort, double speedAmount,
			double speedDirection, double headAngle, int kickCount,
			int dashCount, int turnCount, int sayCount, int turnNeckCount,
			int catchCount, int moveCount, int changeViewCount) {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see atan.model.ControllerPlayer#postInfo()
	 */
	@Override
	public void postInfo() {
		// TODO Auto-generated method stub
	}

	/* (non-Javadoc)
	 * @see atan.model.ControllerPlayer#preInfo()
	 */
	@Override
	public void preInfo() {
		// TODO Auto-generated method stub
	}

	/* (non-Javadoc)
	 * @see atan.model.ControllerPlayer#setPlayer(atan.model.ActionsPlayer)
	 */
	@Override
	public void setPlayer(ActionsPlayer p) {
		this.player = p;
	}

	/* (non-Javadoc)
	 * @see atan.model.ControllerPlayer#setType(java.lang.String)
	 */
	@Override
	public void setType(String newType) {
		// TODO Auto-generated method stub

	}
	
    /**
     * Random x position.
     *
     * @return the int
     */
    private int randomXPosition() {
    	return random.nextInt(55) - 54;
    }
    
    /**
     * Random y position.
     *
     * @return the int
     */
    private int randomYPosition() {
    	return random.nextInt(21) - 10; 
    }
}
