package body Transient_Signals is

   protected body Transient_Signal is
      procedure Send is
      begin
         --  keep the signal only if at least one process
         --+ is waiting for it, but allow only 1 release
         if Wait'Count > 0 then
            Arrived := True;
            Release_All := False;
            end if;
      end Send;
      procedure Send_All is
      begin
         --  as for Send, but allow >1 releases
         if Wait'Count > 0 then
            Arrived := True;
            Release_All := True;
         end if;
      end Send_All;
      entry Wait when Arrived is
      begin
         --  release >1 if last call was Send_All
         if Wait'Count = 0 or not Release_All then
            Arrived := False;
         end if;
      end Wait;
   end Transient_Signal;

end Transient_Signals;
