--------------------------------------------------------
--  Copyright (C) 2006                                --
--  Alessandro Temil                                  --
--  Railway 1.0                                       --
--  Concurrent and Distributed Systems class project  --
--  Master Degree in Computer Science                 --
--  Academic year 2005/6                              --
--  Dept. of Pure and Applied Mathematics             --
--  University of Padua, Italy                        --
--                                                    --
--  This program is free software; you can            --
--  redistribute it and/or modify it under the terms  --
--  of the GNU General Public License as published    --
--  by the Free Software Foundation; either           --
--  version 2 of the License, or (at your option)     --
--  any later version.                                --
--------------------------------------------------------

with Gdk;                use Gdk;
with Gdk.Threads;
with Gtk;                use Gtk;
with Gtk.Main;
with GUI_Control;

package body Distrailway.Nbdisp is

   procedure Dispatch_Notice_Boards
     (Time : Integer;
      Station : String;
      Platform : String;
      Object : String) is
   begin
      for T in Noticeboards'Range loop
         if Noticeboards (T).Station.all = Station then
            Noticeboards (T).Process_Event
              (Time, --  Station,
               Platform, Object);
         end if;
      end loop;
   end Dispatch_Notice_Boards;

   function Tab_Scroll return Boolean is
   begin
      for T in Noticeboards'Range loop
         Noticeboards (T).Scroll_Tab;
      end loop;
      return True;
   end Tab_Scroll;

   protected body Notice_Board_T is

      entry scroll_Tab when Inited is
      begin
         Notice_Boards_View.Scroll_Up (Tab);
      end scroll_Tab;

      entry Process_Event
        (Time : Integer;
         --  Station_From : String;
         Platform : String;
         Object : String) when Inited is
      begin
         Gdk.Threads.Enter;
         Notice_Boards_View.Add_Line (Tab, Platform, Object, Time);
         Gdk.Threads.Leave;
      end Process_Event;

      entry Init when True is
      begin
         Gdk.Threads.Enter;
         Gtk_New(gui_Tab, Station.all, Tab);
         Show_All(gui_Tab);
         Gdk.Threads.Leave;
         Inited := True;
      end Init;

   end Notice_Board_T;

   task body GTK_Task is
      idlef : Gtk.Main.Idle_Handler_Id ;
   begin
      GUI_Control.GUI.Init ("notice boards");
      for T in Noticeboards'Range loop
         Noticeboards (T).Init;
      end loop;
      Gdk.Threads.Enter;
      idlef := Gtk.Main.Idle_Add (Tab_Scroll'Access);
      Gdk.Threads.Leave;
      pkg_Init := True;
   end GTK_Task;

end Distrailway.Nbdisp;
