--------------------------------------------------------
--  Copyright (C) 2006                                --
--  Alessandro Temil                                  --
--  Railway 1.0                                       --
--  Concurrent and Distributed Systems class project  --
--  Master Degree in Computer Science                 --
--  Academic year 2005/6                              --
--  Dept. of Pure and Applied Mathematics             --
--  University of Padua, Italy                        --
--                                                    --
--  This program is free software; you can            --
--  redistribute it and/or modify it under the terms  --
--  of the GNU General Public License as published    --
--  by the Free Software Foundation; either           --
--  version 2 of the License, or (at your option)     --
--  any later version.                                --
--------------------------------------------------------

with Gui_Notice_Board_Pkg; use Gui_Notice_Board_Pkg;
with Notice_Boards_View;   use Notice_Boards_View;
with Railway;              use Railway;

package Distrailway.Nbdisp is

   type String_Ref_T is access all String;
   type Notice_Board_T;
   type Notice_Board_Ref_T is access all Notice_Board_T;

   procedure Dispatch_Notice_Boards
     (Time : Integer;
      Station : String;
      Platform : String;
      Object : String);

   task GTK_Task;

   protected type Notice_Board_T(Station : String_Ref_T) is

      entry Process_Event
        (Time : Integer;
         --  Station_From : String;
         Platform : String;
         Object : String);

      entry scroll_Tab;

      entry Init;

   private

      Inited : Boolean := False;
      gui_Tab : Gui_Notice_Board_Access;
      Tab : Table_T;

   end Notice_Board_T;

   Notice_Board_VE : aliased Notice_Board_T(VENEZIASTNAME'Access);
   Notice_Board_MA : aliased Notice_Board_T(MADRIDSTNAME'Access);
   Notice_Board_BR : aliased Notice_Board_T(BRUXELLESSTNAME'Access);
   Notice_Board_PA : aliased Notice_Board_T(PARISSTNAME'Access);
   Notice_Board_VI : aliased Notice_Board_T(WIENSTNAME'Access);

   Noticeboards : array (Integer range <>) of Notice_Board_Ref_T :=
     (Notice_Board_VE'Access,
      Notice_Board_MA'Access,
      Notice_Board_BR'Access,
      Notice_Board_PA'Access,
      Notice_Board_VI'Access);

private

   pkg_Init : Boolean := False;

end Distrailway.Nbdisp;
