--------------------------------------------------------
--  Copyright (C) 2006                                --
--  Alessandro Temil                                  --
--  Railway 1.0                                       --
--  Concurrent and Distributed Systems class project  --
--  Master Degree in Computer Science                 --
--  Academic year 2005/6                              --
--  Dept. of Pure and Applied Mathematics             --
--  University of Padua, Italy                        --
--                                                    --
--  This program is free software; you can            --
--  redistribute it and/or modify it under the terms  --
--  of the GNU General Public License as published    --
--  by the Free Software Foundation; either           --
--  version 2 of the License, or (at your option)     --
--  any later version.                                --
--------------------------------------------------------

with Gtk;                        use Gtk;
with Trains_View;
with Passengers_View;
with Gdk.Threads;
with GUI_Control;

package body Distrailway.pkgProtectedControl is

   protected body ProtectedControl is

      entry Update_Trains
        (Time : Integer;
         Train_Number : Integer;
         Train_Name : String;
         Free_Seats : Integer;
         Seats : Integer;
         Location : String) when Inited is
      begin
         Gdk.Threads.Enter;
         Trains_View.Add_Line
           (Time, Train_Number, Train_Name,
            Free_Seats, Seats ,Location);
         Gdk.Threads.Leave;
      end Update_Trains;

      entry Update_Passengers
        (Time : Integer;
         Passenger_Name : String;
         Location : String) when Inited is
      begin
         Gdk.Threads.Enter;
         Passengers_View.Add_Line (Time, Passenger_Name, Location);
         Gdk.Threads.Leave;
      end Update_Passengers;

      procedure Initialized is
      begin
         Inited := True;
      end Initialized;

   end ProtectedControl;

   task body GUI_Control_Task is
   begin
      GUI_Control.GUI.Init ("Control Panel");

      Gdk.Threads.Enter;
      Gtk_New (Gui_Control_Trains);
      Gtk_New (Gui_Control_Passengers);
      Show_All (Gui_Control_Trains);
      Show_All (Gui_Control_Passengers);
      Gdk.Threads.Leave;

      ProtectedControl.Initialized;
   end GUI_Control_Task;

end Distrailway.pkgProtectedControl;
