--------------------------------------------------------
--  Copyright (C) 2006                                --
--  Alessandro Temil                                  --
--  Railway 1.0                                       --
--  Concurrent and Distributed Systems class project  --
--  Master Degree in Computer Science                 --
--  Academic year 2005/6                              --
--  Dept. of Pure and Applied Mathematics             --
--  University of Padua, Italy                        --
--                                                    --
--  This program is free software; you can            --
--  redistribute it and/or modify it under the terms  --
--  of the GNU General Public License as published    --
--  by the Free Software Foundation; either           --
--  version 2 of the License, or (at your option)     --
--  any later version.                                --
--------------------------------------------------------

with Glib;             use Glib;
with Gtk;              use Gtk;
with Gtk.Enums;        use Gtk.Enums;
with GUI_Railway_Intl; use GUI_Railway_Intl;
with Gui_Sizes;        use Gui_Sizes;
with Passengers_View;

package body Gui_Control_Passengers_Pkg is

   procedure Gtk_New
     (Gui_Control_Passengers : out Gui_Control_Passengers_Access) is
   begin
      Gui_Control_Passengers := new Gui_Control_Passengers_Record;
      Gui_Control_Passengers_Pkg.Initialize (Gui_Control_Passengers);
   end Gtk_New;

   procedure Initialize
     (Gui_Control_Passengers : access Gui_Control_Passengers_Record'Class) is
      pragma Suppress (All_Checks);
      --  Pixmaps_Dir : constant String := "pixmaps/";
   begin
      Gtk.Window.Initialize (Gui_Control_Passengers, Window_Toplevel);
      Set_Title (Gui_Control_Passengers, -"Control Panel - Passengers");
      Set_Position (Gui_Control_Passengers, Win_Pos_Center);
      Set_Modal (Gui_Control_Passengers, False);

      Set_Default_Size (Gui_Control_Passengers,
                        Passenger_Control_Window_Width,
                        Passenger_Control_Window_Height);

      Gtk_New_Vbox (Gui_Control_Passengers.Vbox2, False, 0);

      Gtk_New (Gui_Control_Passengers.Label2,
               -("CURRENT STATUS OF ALL PASSENGERS"));
      Set_Alignment (Gui_Control_Passengers.Label2, 0.5, 0.5);
      Set_Padding (Gui_Control_Passengers.Label2, 0, 0);
      Set_Justify (Gui_Control_Passengers.Label2, Justify_Left);
      Set_Line_Wrap (Gui_Control_Passengers.Label2, False);
      Set_Selectable (Gui_Control_Passengers.Label2, False);
      Set_Use_Markup (Gui_Control_Passengers.Label2, False);
      Set_Use_Underline (Gui_Control_Passengers.Label2, False);

      Pack_Start
        (Gui_Control_Passengers.Vbox2,
         Gui_Control_Passengers.Label2,
         Expand  => False,
         Fill    => False,
         Padding => 0);
      Gtk_New (Gui_Control_Passengers.Scrolledwindow2);
      Set_Policy (Gui_Control_Passengers.Scrolledwindow2,
                  Policy_Automatic, Policy_Automatic);
      Set_Shadow_Type (Gui_Control_Passengers.Scrolledwindow2, Shadow_In);

      Gtk_New (Gui_Control_Passengers.View_Passengers);
      Set_Headers_Visible (Gui_Control_Passengers.View_Passengers, True);

      Set_Rules_Hint (Gui_Control_Passengers.View_Passengers, False);
      Set_Reorderable (Gui_Control_Passengers.View_Passengers, False);
      Set_Enable_Search (Gui_Control_Passengers.View_Passengers, True);

      Passengers_View.Run(Gui_Control_Passengers.Scrolledwindow2);

      Pack_Start
        (Gui_Control_Passengers.Vbox2,
         Gui_Control_Passengers.Scrolledwindow2,
         Expand  => True,
         Fill    => True,
         Padding => 0);
      Add (Gui_Control_Passengers, Gui_Control_Passengers.Vbox2);
   end Initialize;

end Gui_Control_Passengers_Pkg;
