--------------------------------------------------------
--  Copyright (C) 2006                                --
--  Alessandro Temil                                  --
--  Railway 1.0                                       --
--  Concurrent and Distributed Systems class project  --
--  Master Degree in Computer Science                 --
--  Academic year 2005/6                              --
--  Dept. of Pure and Applied Mathematics             --
--  University of Padua, Italy                        --
--                                                    --
--  This program is free software; you can            --
--  redistribute it and/or modify it under the terms  --
--  of the GNU General Public License as published    --
--  by the Free Software Foundation; either           --
--  version 2 of the License, or (at your option)     --
--  any later version.                                --
--------------------------------------------------------

with Glib;             use Glib;
with Gtk;              use Gtk;
with Gtk.Enums;        use Gtk.Enums;
with GUI_Railway_Intl; use GUI_Railway_Intl;
with Trains_View;      use Trains_View;
with Gui_Sizes;        use Gui_Sizes;

package body Gui_Control_Trains_Pkg is

   procedure Gtk_New (Gui_Control_Trains : out Gui_Control_Trains_Access) is
   begin
      Gui_Control_Trains := new Gui_Control_Trains_Record;
      Gui_Control_Trains_Pkg.Initialize (Gui_Control_Trains);
   end Gtk_New;

   procedure Initialize
     (Gui_Control_Trains : access Gui_Control_Trains_Record'Class) is
      pragma Suppress (All_Checks);
      --  Pixmaps_Dir : constant String := "pixmaps/";
   begin
      Gtk.Window.Initialize (Gui_Control_Trains, Window_Toplevel);
      Set_Title (Gui_Control_Trains, -"Control Panel - Trains");
      Set_Position (Gui_Control_Trains, Win_Pos_Center);
      Set_Modal (Gui_Control_Trains, False);

      Set_Default_Size (Gui_Control_Trains,
                        Train_Control_Window_Width,
                        Train_Control_Window_Height);

      Gtk_New_Vbox (Gui_Control_Trains.Vbox1, False, 0);

      Gtk_New (Gui_Control_Trains.Label1, -("CURRENT STATUS OF ALL TRAINS"));
      Set_Alignment (Gui_Control_Trains.Label1, 0.5, 0.5);
      Set_Padding (Gui_Control_Trains.Label1, 0, 0);
      Set_Justify (Gui_Control_Trains.Label1, Justify_Left);
      Set_Line_Wrap (Gui_Control_Trains.Label1, False);
      Set_Selectable (Gui_Control_Trains.Label1, False);
      Set_Use_Markup (Gui_Control_Trains.Label1, False);
      Set_Use_Underline (Gui_Control_Trains.Label1, False);

      Pack_Start
        (Gui_Control_Trains.Vbox1,
         Gui_Control_Trains.Label1,
         Expand  => False,
         Fill    => False,
         Padding => 0);
      Gtk_New (Gui_Control_Trains.Scrolledwindow1);
      Set_Policy (Gui_Control_Trains.Scrolledwindow1,
                  Policy_Automatic, Policy_Automatic);
      Set_Shadow_Type (Gui_Control_Trains.Scrolledwindow1, Shadow_In);

      Gtk_New (Gui_Control_Trains.View_Trains);
      Set_Headers_Visible (Gui_Control_Trains.View_Trains, True);
      Set_Rules_Hint (Gui_Control_Trains.View_Trains, True);
      Set_Reorderable (Gui_Control_Trains.View_Trains, False);
      Set_Enable_Search (Gui_Control_Trains.View_Trains, True);

      Trains_View.Run(Gui_Control_Trains.Scrolledwindow1);

      Pack_Start
        (Gui_Control_Trains.Vbox1,
         Gui_Control_Trains.Scrolledwindow1,
         Expand  => True,
         Fill    => True,
         Padding => 0);
      Add (Gui_Control_Trains, Gui_Control_Trains.Vbox1);

   end Initialize;

end Gui_Control_Trains_Pkg;
