--------------------------------------------------------
--  Copyright (C) 2006                                --
--  Alessandro Temil                                  --
--  Railway 1.0                                       --
--  Concurrent and Distributed Systems class project  --
--  Master Degree in Computer Science                 --
--  Academic year 2005/6                              --
--  Dept. of Pure and Applied Mathematics             --
--  University of Padua, Italy                        --
--                                                    --
--  This program is free software; you can            --
--  redistribute it and/or modify it under the terms  --
--  of the GNU General Public License as published    --
--  by the Free Software Foundation; either           --
--  version 2 of the License, or (at your option)     --
--  any later version.                                --
--------------------------------------------------------

with Glib;               use Glib;
with Gtk;                use Gtk;
with Gtk.Enums;          use Gtk.Enums;
with GUI_Railway_Intl;   use GUI_Railway_Intl;
with Gui_Sizes;          use Gui_Sizes;

package body Gui_Notice_Board_Pkg is

   procedure Gtk_New
     (Gui_Notice_Board :    out Gui_Notice_Board_Access;
      Station          :        String;
      Tab              : in out Table_T) is
   begin
      Gui_Notice_Board := new Gui_Notice_Board_Record;
      Gui_Notice_Board.StationName := new String'(Station);
      Gui_Notice_Board_Pkg.Initialize (Gui_Notice_Board, Station, Tab);
   end Gtk_New;

   procedure Initialize
     (Gui_Notice_Board : access Gui_Notice_Board_Record'Class;
      Station          : String;
      Tab              : in out Table_T) is
   pragma Suppress (All_Checks);
      --  Pixmaps_Dir : constant String := "pixmaps/";
   begin
      Gtk.Window.Initialize (Gui_Notice_Board, Window_Toplevel);
      Set_Title (Gui_Notice_Board, Station & " - Time Table");
      Set_Position (Gui_Notice_Board, Win_Pos_None);
      Set_Modal (Gui_Notice_Board, False);

      Set_Default_Size (Gui_Notice_Board,
                        Notice_Board_Window_Width,
                        Notice_Board_Window_Height);

      Gtk_New (Gui_Notice_Board.Scrolledwindow3);
      Set_Policy (Gui_Notice_Board.Scrolledwindow3,
                  Policy_Automatic,
                  Policy_Automatic);
      Set_Shadow_Type (Gui_Notice_Board.Scrolledwindow3, Shadow_In);

      Gtk_New (Gui_Notice_Board.Viewport1);
      Set_Shadow_Type (Gui_Notice_Board.Viewport1, Shadow_In);

      Gtk_New_Vbox (Gui_Notice_Board.Vbox3, False, 0);

      Gtk_New (Gui_Notice_Board.Label3, -(Station & " - Time Table"));
      Set_Alignment (Gui_Notice_Board.Label3, 0.5, 0.5);
      Set_Padding (Gui_Notice_Board.Label3, 0, 0);
      Set_Justify (Gui_Notice_Board.Label3, Justify_Left);
      Set_Line_Wrap (Gui_Notice_Board.Label3, False);
      Set_Selectable (Gui_Notice_Board.Label3, False);
      Set_Use_Markup (Gui_Notice_Board.Label3, False);
      Set_Use_Underline (Gui_Notice_Board.Label3, False);

      Pack_Start
        (Gui_Notice_Board.Vbox3,
         Gui_Notice_Board.Label3,
         Expand  => False,
         Fill    => False,
         Padding => 0);
      Gtk_New (Gui_Notice_Board.Scrolledwindow4);
      Set_Policy (Gui_Notice_Board.Scrolledwindow4,
                  Policy_Automatic,
                  Policy_Always);
      Set_Shadow_Type (Gui_Notice_Board.Scrolledwindow4, Shadow_In);

      Gtk_New (Gui_Notice_Board.Treeview2);
      Set_Headers_Visible (Gui_Notice_Board.Treeview2, True);
      Set_Rules_Hint (Gui_Notice_Board.Treeview2, False);
      Set_Reorderable (Gui_Notice_Board.Treeview2, False);
      Set_Enable_Search (Gui_Notice_Board.Treeview2, True);

      --  Add (Gui_Notice_Board.Scrolledwindow4, Gui_Notice_Board.Treeview2);

      Notice_Boards_View.Run(Gui_Notice_Board.Scrolledwindow4, Tab);

      Pack_Start
        (Gui_Notice_Board.Vbox3,
         Gui_Notice_Board.Scrolledwindow4,
         Expand  => True,
         Fill    => True,
         Padding => 0);
      Add (Gui_Notice_Board.Viewport1, Gui_Notice_Board.Vbox3);
      Add (Gui_Notice_Board.Scrolledwindow3, Gui_Notice_Board.Viewport1);
      Add (Gui_Notice_Board, Gui_Notice_Board.Scrolledwindow3);
   end Initialize;

end Gui_Notice_Board_Pkg;
