--------------------------------------------------------
--  Copyright (C) 2006                                --
--  Alessandro Temil                                  --
--  Railway 1.0                                       --
--  Concurrent and Distributed Systems class project  --
--  Master Degree in Computer Science                 --
--  Academic year 2005/6                              --
--  Dept. of Pure and Applied Mathematics             --
--  University of Padua, Italy                        --
--                                                    --
--  This program is free software; you can            --
--  redistribute it and/or modify it under the terms  --
--  of the GNU General Public License as published    --
--  by the Free Software Foundation; either           --
--  version 2 of the License, or (at your option)     --
--  any later version.                                --
--------------------------------------------------------

with Gtk.Window;          use Gtk.Window;
with Gtk.Scrolled_Window; use Gtk.Scrolled_Window;
with Gtk.Viewport;        use Gtk.Viewport;
with Gtk.Box;             use Gtk.Box;
with Gtk.Label;           use Gtk.Label;
with Gtk.Tree_View;       use Gtk.Tree_View;
with Notice_Boards_View;  use Notice_Boards_View;

package Gui_Notice_Board_Pkg is

   type String_Ref_T is access all String;

   type Gui_Notice_Board_Record is new Gtk_Window_Record with record
      StationName : String_Ref_T;
      Scrolledwindow3 : Gtk_Scrolled_Window;
      Viewport1 : Gtk_Viewport;
      Vbox3 : Gtk_Vbox;
      Label3 : Gtk_Label;
      Scrolledwindow4 : Gtk_Scrolled_Window;
      Treeview2 : Gtk_Tree_View;
   end record;

   type Gui_Notice_Board_Access is
     access Gui_Notice_Board_Record'Class;

   procedure Gtk_New
     (Gui_Notice_Board : out Gui_Notice_Board_Access;
      Station          : String;
      Tab              : in out Table_T);

   procedure Initialize
     (Gui_Notice_Board : access Gui_Notice_Board_Record'Class;
      Station : String;
      Tab : in out Table_T);

end Gui_Notice_Board_Pkg;
