--------------------------------------------------------
--  Copyright (C) 2006                                --
--  Alessandro Temil                                  --
--  Railway 1.0                                       --
--  Concurrent and Distributed Systems class project  --
--  Master degree in Computer Science                 --
--  Academic year 2005/6                              --
--  Dept. of Pure and Applied Mathematics             --
--  University of Padua, Italy                        --
--                                                    --
--  This program is free software; you can            --
--  redistribute it and/or modify it under the terms  --
--  of the GNU General Public License as published    --
--  by the Free Software Foundation; either           --
--  version 2 of the License, or (at your option)     --
--  any later version.                                --
--------------------------------------------------------

--  This code was re-adapted from the example code of the
--+ GtkAda Toolkit. Below the original copyright notice

-----------------------------------------------------------------------
--          GtkAda - Ada95 binding for the Gimp Toolkit              --
--                                                                   --
--                     Copyright (C) 2003                            --
--        Emmanuel Briot, Joel Brobecker and Arnaud Charlet          --
--                                                                   --
-- This library is free software; you can redistribute it and/or     --
-- modify it under the terms of the GNU General Public               --
-- License as published by the Free Software Foundation; either      --
-- version 2 of the License, or (at your option) any later version.  --
--                                                                   --
-- This library is distributed in the hope that it will be useful,   --
-- but WITHOUT ANY WARRANTY; without even the implied warranty of    --
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU --
-- General Public License for more details.                          --
--                                                                   --
-- You should have received a copy of the GNU General Public         --
-- License along with this library; if not, write to the             --
-- Free Software Foundation, Inc., 59 Temple Place - Suite 330,      --
-- Boston, MA 02111-1307, USA.                                       --
--                                                                   --
-- As a special exception, if other files instantiate generics from  --
-- this unit, or you link this unit with other files to produce an   --
-- executable, this  unit  does not  by itself cause  the resulting  --
-- executable to be covered by the GNU General Public License. This  --
-- exception does not however invalidate any other reasons why the   --
-- executable file  might be covered by the  GNU Public License.     --
-----------------------------------------------------------------------

with Glib;                     use Glib;
with Glib.Object;              use Glib.Object;
with Glib.Values;              use Glib.Values;
with Gtk;                      use Gtk;
with Gtk.Enums;                use Gtk.Enums;
with Gtk.Scrolled_Window;      use Gtk.Scrolled_Window;
with Gtk.Cell_Renderer_Text;   use Gtk.Cell_Renderer_Text;
with Gtk.Cell_Renderer_Toggle; use Gtk.Cell_Renderer_Toggle;
with Gtk.Tree_View;            use Gtk.Tree_View;
with Gtk.Tree_Model;           use Gtk.Tree_Model;
with Gtk.Tree_Store;           use Gtk.Tree_Store;
with Gtk.Tree_View_Column;     use Gtk.Tree_View_Column;
with Gtk.Handlers;             use Gtk.Handlers;
with Gtk.Adjustment;           use Gtk.Adjustment;

package body Notice_Boards_View is

   package Object_Callback is new Gtk.Handlers.Callback (GObject_Record);

   Platform_Column   : constant := 0;
   Event_Column      : constant := 1;
   Foreground_Column : constant := 2;
   Time_Column       : constant := 3;

   type String_Ref_T is access all String;

   type Platform_Iter_T is record
      Platform : String_Ref_T := null;
      Iter  : Gtk_Tree_Iter := Null_Iter;
   end record;

   type Known_Platforms_T is array (1..100) of Platform_Iter_T;

   Known_Platforms : Known_Platforms_T;

   Next_Platform : Integer := Known_Platforms'First;
   --  Insert a new line in the tree, as a child of Parent (or as a root node)
   --+ if Parent is Null_Iter.

   procedure Edited_Callback
     (Model  : access GObject_Record'Class;
      Params : Glib.Values.GValues);
   --  Called when the user clicks on a toggle button. This is used to reflect
   --  (or not) the change in the model.

   procedure Text_Edited_Callback
     (Model  : access GObject_Record'Class;
      Params : Glib.Values.GValues);
   --  Same when a text cell is edited

   ----------
   -- Help --
   ----------

   function Help return String is
   begin
      return "A @bGtk_Tree_View@B is a widget used to display a number of"
        & " lines, organized either as a simple list or into a tree"
        & " hierarchy." & ASCII.LF
        & "Each line can contain multiple resizable column, each of which"
        & " can contain pixmaps, texts, or both. The columns can be sorted"
        & " interactively by the user by clicking on the column header."
        & ASCII.LF
        & "Like the @bGtk_Text_View@B, this widget is based on the model-"
        & "view-controller paradigm: data is stored in a non graphical"
        & " object (a @bGtk_Tree_Model@B), which is then associated with"
        & " one or many view. The model provides subprograms for inserting"
        & " or removing lines, as well as for traversing an existing tree."
        & ASCII.LF
        & "Cells in the tree can be defined as editable, as shown in this"
        & " example: in this case, the user needs to double click on the"
        & " cell, and an entry widget is then displayed in which the text"
        & " can be modified";
   end Help;

   --------------
   -- Add_Line --
   --------------

   procedure Add_Line
     --(Model    : access Gtk_Tree_Store_Record'Class;
     (Tab : in out Table_T;
      Platform : String;
      Event : String;
      Time : Integer;
      Parent   : Gtk_Tree_Iter := Null_Iter) is
      Iters : Gtk_Tree_Iter;

      --  package Tree_Cb is new Handlers.Callback (Gtk_Tree_View_Record);

   begin
      --  The implementation here is not the most efficient:
      --+ it is often easier to import yourself the function
      --+ gtk_tree_store_set with the correct set of arguments,
      --+ as shown in the example in gtk-tree_store.ads

      for I in Known_Platforms'Range loop
         if Known_Platforms (I).Platform /= null then
            if Known_Platforms (I).Platform.all = Platform then
               Set (Tab.Model, Known_Platforms (I).Iter,
                    Event_Column, Event);
               Set (Tab.Model, Known_Platforms (I).Iter,
                    Time_Column, Gint (Time));
               Draw (Tab.Tree);
               return;
            end if;
         end if;
      end loop;

      Prepend (Tab.Model, Iters, Parent);

      Set (Tab.Model, Iters, Platform_Column, Platform);
      Set (Tab.Model, Iters, Event_Column, Event);
      Set (Tab.Model, Iters, Time_Column, Gint (Time));
      Set (Tab.Model, Iters, Foreground_Column, "black");

      Known_Platforms (Next_Platform).Platform := new String'(Platform);
      Known_Platforms (Next_Platform).Iter := Iters;

      Next_Platform := Next_Platform + 1;

      Draw (Tab.Tree);

      Tab.Iter := Iters;

   end Add_Line;

   procedure Scroll_Up (Tab : in out Table_T) is

       Fadj : Gtk_Adjustment;

   begin

      Fadj := Get_Vadjustment (Tab.Tree);
      Set_Value (Fadj, Get_Lower (Fadj));

   end Scroll_Up;

   ---------------------
   -- Edited_Callback --
   ---------------------

   procedure Edited_Callback
     (Model  : access GObject_Record'Class;
      Params : Glib.Values.GValues)
   is
      --  M             : constant Gtk_Tree_Store := Gtk_Tree_Store (Model);
      --  Path_String   : constant String := Get_String (Nth (Params, 1));
      --  Iter          : constant Gtk_Tree_Iter :=
      --+   Get_Iter_From_String (M, Path_String);
   begin
      null;
   end Edited_Callback;

   --------------------------
   -- Text_Edited_Callback --
   --------------------------

   procedure Text_Edited_Callback
     (Model  : access GObject_Record'Class;
      Params : Glib.Values.GValues)
   is
      --  M             : constant Gtk_Tree_Store := Gtk_Tree_Store (Model);
      --  Path_String   : constant String := Get_String (Nth (Params, 1));
      --  Text_Value    : constant GValue := Nth (Params, 2);
      --  Iter          : Gtk_Tree_Iter :=
      --+   Get_Iter_From_String (M, Path_String);
   begin
      null;
   end Text_Edited_Callback;

   ---------
   -- Run --
   ---------

   procedure Run
     (Frame : access Gtk_Scrolled_Window_Record'Class;
      Tab : in out Table_T) is

   begin
      --  Create the model that contains the actual data. In this example,
      --  we create this as a tree, although it could also be a simple list.
      --
      --  Each data is in fact a line in the graphical widget, and can contain
      --  multiple columns, not all of which are visible at any time. Some can
      --  be used as flags to indicate how the rendering should be done.

      Gtk_New (Tab.Model,
               (Platform_Column   => GType_String,
                Event_Column      => GType_String,
                Time_Column       => GType_Int,
                Foreground_Column => GType_String));

      --  Create the view: it shows two columns, the first contains some text,
      --  the second contains a toggle button. In each column, a renderer is
      --  used to display the data graphically. In the future, it will be
      --  possible to create your own renderers with GtkAda. For now, we simply
      --  use two of the predefined renderers. The list of possible attributes
      --  for these is defined in their respective packages.

      Gtk_New (Tab.Tree, Tab.Model);

      Gtk_New (Tab.Text_Render);
      Gtk_New (Tab.Toggle_Render);

      Gtk_New (Tab.Col);
      Tab.Num := Append_Column (Tab.Tree, Tab.Col);
      Set_Title (Tab.Col, "Platform");
      Pack_Start (Tab.Col, Tab.Text_Render, True);
      Add_Attribute (Tab.Col, Tab.Text_Render,
                     "text", Platform_Column);
      Add_Attribute (Tab.Col, Tab.Text_Render,
                     "foreground", Foreground_Column);

      Gtk_New (Tab.Col);
      Tab.Num := Append_Column (Tab.Tree, Tab.Col);
      Set_Title (Tab.Col, "Event");
      Pack_Start (Tab.Col, Tab.Text_Render, True);
      Add_Attribute (Tab.Col, Tab.Text_Render,
                     "text", Event_Column);
      Add_Attribute (Tab.Col, Tab.Text_Render,
                     "foreground", Foreground_Column);

      Gtk_New (Tab.Col);
      Tab.Num := Append_Column (Tab.Tree, Tab.Col);
      Set_Title (Tab.Col, "Time");
      Pack_Start (Tab.Col, Tab.Text_Render, True);
      Add_Attribute (Tab.Col, Tab.Text_Render,
                     "text", Time_Column);
      Add_Attribute (Tab.Col, Tab.Text_Render,
                     "foreground", Foreground_Column);

      --  By default, the toggle renderer doesn't react to clicks, ie the user
      --  cannot interactively change the value of the radio button. This needs
      --  a special callback for the "edited" signal.
      --  The same applies for text renderers.
      --
      --  In both cases, the callback should be used for validation of the
      --  input.

      Object_Callback.Object_Connect
        (Tab.Toggle_Render, "toggled", Edited_Callback'Access,
         Slot_Object => Tab.Model);
      Object_Callback.Object_Connect
        (Tab.Text_Render, "edited", Text_Edited_Callback'Access,
         Slot_Object => Tab.Model);

      --  Insert some data in the tree

      Tab.Parent := Null_Iter;

      --  Insert the view in the frame

      Gtk_New (Tab.Scrolled);
      Set_Policy (Tab.Scrolled, Policy_Always, Policy_Always);

      Add (Frame, Tab.Tree);

   end Run;

end Notice_Boards_View;
