--------------------------------------------------------
--  Copyright (C) 2006                                --
--  Alessandro Temil                                  --
--  Railway 1.0                                       --
--  Concurrent and Distributed Systems class project  --
--  Master Degree in Computer Science                 --
--  Academic year 2005/6                              --
--  Dept. of Pure and Applied Mathematics             --
--  University of Padua, Italy                        --
--                                                    --
--  This program is free software; you can            --
--  redistribute it and/or modify it under the terms  --
--  of the GNU General Public License as published    --
--  by the Free Software Foundation; either           --
--  version 2 of the License, or (at your option)     --
--  any later version.                                --
--------------------------------------------------------

with Railway.Track;          use Railway.Track;
with Railway.Train;          use Railway.Train;
with Railway.Platform;       use Railway.Platform;
with Railway.Ticket_Counter; use Railway.Ticket_Counter;
with Ada.Strings.Unbounded;  use Ada.Strings.Unbounded;

package Railway.Network is

   type Station_Map_T is record
      Num : Station_T;
      Name : Unbounded_String;
   end record;

   type Stations_T is array (Integer range <>) of Station_Map_T;

   Stations_Map : Stations_T :=
     ((Venezia, To_Unbounded_String (VENEZIASTNAME)),
      (Madrid, To_Unbounded_String (MADRIDSTNAME)),
      (Paris, To_Unbounded_String (PARISSTNAME)),
      (Wien, To_Unbounded_String (WIENSTNAME)),
      (Bruxelles, To_Unbounded_String (BRUXELLESSTNAME)));

   --  Track Names
   Br_Wi_Track : aliased String := ("Bruxelles - Wien (bidirectional)");
   Br_Pa_Track : aliased String := ("Bruxelles - Paris (unidirectional)");
   Pa_Br_Track : aliased String := ("Paris - Bruxelles (unidirectional)");
   Pa_Ve_Track : aliased String := ("Paris - Venezia (unidirectional)");
   Ve_Pa_Track : aliased String := ("Venezia - Paris (unidirectional)");
   Pa_Ma_Track : aliased String := ("Paris - Madrid (unidirectional)");
   Ma_Pa_Track : aliased String := ("Madrid - Paris (unidirectional)");

   --  Tracks
   --+-------
   --  DISCLAIMER: lengths are assigned to tracks
   --+ with no regard to real physical distances
   --+-------
   BR_WI : aliased Track_T (5_000, Br_Wi_Track'Access);
   BR_PA : aliased Track_T (3_000, Br_Pa_Track'Access);
   PA_BR : aliased Track_T (3_000, Pa_Br_Track'Access);
   VE_PA : aliased Track_T (3_000, Ve_Pa_Track'Access);
   PA_VE : aliased Track_T (3_000, Pa_Ve_Track'Access);
   PA_MA : aliased Track_T (4_000, Pa_Ma_Track'Access);
   MA_PA : aliased Track_T (4_000, Ma_Pa_Track'Access);

   --  Segments
   Bruxelles_Wien : Segment_T := BR_WI'Access;
   Wien_Bruxelles : Segment_T := BR_WI'Access;

   Paris_Bruxelles : Segment_T := PA_BR'Access;
   Bruxelles_Paris : Segment_T := BR_PA'Access;

   Venezia_Paris : Segment_T := VE_PA'Access;
   Paris_Venezia : Segment_T := PA_VE'Access;

   Paris_Madrid : Segment_T := PA_MA'Access;
   Madrid_Paris : Segment_T := MA_PA'Access;

   --  Ticket counter Names
   Ticket_Counter : constant String := "ticket counter";
   TC_VENEZIA   : aliased String := "Venezia " & Ticket_Counter;
   TC_MADRID    : aliased String := "Madrid " & Ticket_Counter;
   TC_PARIS     : aliased String := "Paris " & Ticket_Counter;
   TC_BRUXELLES : aliased String := "Bruxelles " & Ticket_Counter;
   TC_WIEN      : aliased String := "Wien " & Ticket_Counter;

   --  Ticket counters
   Ticket_Counter_Venezia   : aliased Ticket_Counter_T (TC_VENEZIA'Access);
   Ticket_Counter_Madrid    : aliased Ticket_Counter_T (TC_MADRID'Access);
   Ticket_Counter_Paris     : aliased Ticket_Counter_T (TC_PARIS'Access);
   Ticket_Counter_Bruxelles : aliased Ticket_Counter_T (TC_BRUXELLES'Access);
   Ticket_Counter_Wien      : aliased Ticket_Counter_T (TC_WIEN'Access);

   --  Platform Names
   PLVENEZIA1   : aliased String := ("VE-1");
   PLVENEZIA2   : aliased String := ("VE-2");
   PLMADRID1    : aliased String := ("MA-1");
   PLMADRID2    : aliased String := ("MA-2");
   PLPARIS1     : aliased String := ("PA-1");
   PLPARIS2     : aliased String := ("PA-2");
   PLBRUXELLES1 : aliased String := ("BR-1");
   PLBRUXELLES2 : aliased String := ("BR-2");
   PLWIEN1      : aliased String := ("WI-1");
   PLWIEN2      : aliased String := ("WI-2");

   --  Platforms
   Pl_Venezia_1 : aliased Platform_T (PLVENEZIA1'Access,
                                     VENEZIASTNAME'Access);
   Pl_Venezia_2 : aliased Platform_T (PLVENEZIA2'Access,
                                     VENEZIASTNAME'Access);

   Pl_Madrid_1 : aliased Platform_T (PLMADRID1'Access,
                                     MADRIDSTNAME'Access);
   Pl_Madrid_2 : aliased Platform_T (PLMADRID2'Access,
                                     MADRIDSTNAME'Access);

   Pl_Paris_1 : aliased Platform_T (PLPARIS1'Access,
                                    PARISSTNAME'Access);

   Pl_Paris_2 : aliased Platform_T (PLPARIS2'Access,
                                    PARISSTNAME'Access);

   Pl_Bruxelles_1 : aliased Platform_T (PLBRUXELLES1'Access,
                                        BRUXELLESSTNAME'Access);
   Pl_Bruxelles_2 : aliased Platform_T (PLBRUXELLES2'Access,
                                        BRUXELLESSTNAME'Access);

   Pl_Wien_1 : aliased Platform_T (PLWIEN1'Access,
                                     WIENSTNAME'Access);
   Pl_Wien_2 : aliased Platform_T (PLWIEN2'Access,
                                     WIENSTNAME'Access);

   Null_Stage : Stage_T := (null, null, -1);

   --  EuroCity Madrid-Venezia
   EC_MAVE_MA_PA : Stage_T := (Pl_Madrid_1'Access, Madrid_Paris, 1);
   EC_MAVE_PA_VE : Stage_T := (Pl_Paris_2'Access, Paris_Venezia, 2);
   EC_MAVE_VE_PA : Stage_T := (Pl_Venezia_1'Access, Venezia_Paris, 3);
   EC_MAVE_PA_MA : Stage_T := (Pl_Paris_1'Access, Paris_Madrid, 4);

   EC_MAVE_Route : aliased Path_T :=
     (EC_MAVE_MA_PA,
      EC_MAVE_PA_VE,
      EC_MAVE_VE_PA,
      EC_MAVE_PA_MA);

   Madrid_Venezia_EC : aliased String := "[Madrid-Venezia EC]";

   Ticket_DB_ECMAVE : aliased Ticket_DB_T
     (Madrid_Venezia_EC'Access,
      1,
      EC_MAVE_Route'Access,
      1,
      4,
      10);

   EC_MadridVenezia : aliased Train_T
     (EC_MAVE_Route'Access, 10, Priority_EC,
      Madrid_Venezia_EC'Access, 1, EC,
      Ticket_DB_ECMAVE'Access);

   --  EuroCity Wien-Madrid
   EC_VIMA_VI_BR : Stage_T := (Pl_Wien_1'Access, Wien_Bruxelles, 1);
   EC_VIMA_BR_PA : Stage_T := (Pl_Bruxelles_2'Access, Bruxelles_Paris, 2);
   EC_VIMA_PA_MA : Stage_T := (Pl_Paris_1'Access, Paris_Madrid, 3);
   EC_VIMA_MA_PA : Stage_T := (Pl_Madrid_1'Access, Madrid_Paris, 4);
   EC_VIMA_PA_BR : Stage_T := (Pl_Paris_1'Access, Paris_Bruxelles, 5);
   EC_VIMA_BR_VI : Stage_T := (Pl_Bruxelles_1'Access, Bruxelles_Wien, 6);

   EC_VIMA_Route : aliased Path_T :=
     (EC_VIMA_VI_BR,
      EC_VIMA_BR_PA,
      EC_VIMA_PA_MA,
      EC_VIMA_MA_PA,
      EC_VIMA_PA_BR,
      EC_VIMA_BR_VI);

   Wien_Madrid_EC : aliased String := "[Wien-Madrid EC]";

   Ticket_DB_ECVIMA : aliased Ticket_DB_T
     (Wien_Madrid_EC'Access,
      2,
      EC_VIMA_Route'Access,
      1,
      6,
      10);

   EC_WienMadrid : aliased Train_T
     (EC_VIMA_Route'Access, 10, Priority_EC,
      Wien_Madrid_EC'Access, 2, EC,
      Ticket_DB_ECVIMA'Access);

   --  Regular Train Wien-Paris
   RT_VIPA_VI_BR : Stage_T := (Pl_Wien_2'Access, Wien_Bruxelles, 1);
   RT_VIPA_BR_PA : Stage_T := (Pl_Bruxelles_2'Access, Bruxelles_Paris, 2);
   RT_VIPA_PA_BR : Stage_T := (Pl_Paris_2'Access, Paris_Bruxelles, 3);
   RT_VIPA_BR_VI : Stage_T := (Pl_Bruxelles_1'Access, Bruxelles_Wien, 4);

   RT_VIPA_Route : aliased Path_T :=
     (RT_VIPA_VI_BR,
      RT_VIPA_BR_PA,
      RT_VIPA_PA_BR,
      RT_VIPA_BR_VI);

   Wien_Paris_RT : aliased String := "[Wien-Paris RT]";

   RT_WienParis : aliased Train_T
     (RT_VIPA_Route'Access, 10, Priority_IR,
      Wien_Paris_RT'Access, 3, IR,
      null);

    --  EuroCity Bruxelles-Madrid
   EC_BRMA_BR_PA : Stage_T := (Pl_Bruxelles_1'Access, Bruxelles_Paris, 1);
   EC_BRMA_PA_MA : Stage_T := (Pl_Paris_1'Access, Paris_Madrid, 2);
   EC_BRMA_MA_PA : Stage_T := (Pl_Madrid_1'Access, Madrid_Paris, 3);
   EC_BRMA_PA_BR : Stage_T := (Pl_Paris_1'Access, Paris_Bruxelles, 4);

   EC_BRMA_Route : aliased Path_T :=
     (EC_BRMA_BR_PA,
      EC_BRMA_PA_MA,
      EC_BRMA_MA_PA,
      EC_BRMA_PA_BR) ;

   Bruxelles_Madrid_EC : aliased String := "[Bruxelles-Madrid EC]";

   Ticket_DB_ECBRMA : aliased Ticket_DB_T
     (Bruxelles_Madrid_EC'Access,
      4,
      EC_BRMA_Route'Access,
      1,
      4,
      10);

   EC_BruxellesMadrid : aliased Train_T
     (EC_BRMA_Route'Access, 10, Priority_EC,
      Bruxelles_Madrid_EC'Access, 4, EC,
      Ticket_DB_ECBRMA'Access);

   --  Regular Train Bruxelles-Madrid
   RT_BRMA_BR_PA : Stage_T := (Pl_Bruxelles_1'Access, Bruxelles_Paris, 1);
   RT_BRMA_PA_MA : Stage_T := (Pl_Paris_1'Access, Paris_Madrid, 2);
   RT_BRMA_MA_PA : Stage_T := (Pl_Madrid_1'Access, Madrid_Paris, 3);
   RT_BRMA_PA_BR : Stage_T := (Pl_Paris_1'Access, Paris_Bruxelles, 4);

   RT_BRMA_Route : aliased Path_T :=
     (RT_BRMA_BR_PA,
      RT_BRMA_PA_MA,
      RT_BRMA_MA_PA,
      RT_BRMA_PA_BR) ;

   Bruxelles_Madrid_RT : aliased String := "[Bruxelles-Madrid RT]";

    RT_BruxellesMadrid : aliased Train_T
     (RT_BRMA_Route'Access, 10, Priority_IR,
      Bruxelles_Madrid_RT'Access, 5, IR,
      null);

end Railway.Network;
