--------------------------------------------------------
--  Copyright (C) 2006                                --
--  Alessandro Temil                                  --
--  Railway 1.0                                       --
--  Concurrent and Distributed Systems class project  --
--  Master Degree in Computer Science                 --
--  Academic year 2005/6                              --
--  Dept. of Pure and Applied Mathematics             --
--  University of Padua, Italy                        --
--                                                    --
--  This program is free software; you can            --
--  redistribute it and/or modify it under the terms  --
--  of the GNU General Public License as published    --
--  by the Free Software Foundation; either           --
--  version 2 of the License, or (at your option)     --
--  any later version.                                --
--------------------------------------------------------

with Railway;                     use Railway;
with Railway.Track;               use Railway.Track;
with Ada.Real_Time;               use Ada.Real_Time;

package Railway.Platform is

   --  Time that the Trains remain Stopped
   Stop_Time : Time_Span := Milliseconds(1_000);

   type Platform_T;
   type Platform_Ref_T is access all Platform_T;

   type Stage_T is
      record
         Departure_Platform : Platform_Ref_T := null;
         Segment_Route : Segment_T := null;
         Stage_Number : Integer := -1;
      end record;

   type Path_T is array (Integer range <>) of Stage_T;

   type Path_Ref_T is access all Path_T;

   type Ticket_DB_T;

   type Ticket_DB_Ref_T is access all Ticket_DB_T;

   type Leg_T is record
      Train_Name : String_Ref_T;
      Train_Number : Range_Trains;
      Train_Type : Train_Type_T;
      Route : Path_Ref_T;
      Tickets : Ticket_DB_Ref_T;
   end record;

   type Leg_Ref_T is access all Leg_T;

   type Legs_Sequence_T is array (Integer range <>) of Leg_Ref_T;

   type Legs_Sequence_Ref_T is access all Legs_Sequence_T;

   --  controls advancement in simulation Time
   Passed : Time_Span;

   protected type Platform_T
     (Name    : String_Ref_T;
      Station : String_Ref_T) is

      --  called by Trains
      --+ when they Arrive at a Station
      entry Train_Arrived
        (Train_Name : String_Ref_T;
         Train_Number : Range_Trains;
         Free_Seats : Integer;
         Seats : Integer;
         Destination : String_Ref_T);
      --  enqueues at the Platform

      entry Stopping
        (Train_Name : String_Ref_T;
         Train_Number : Range_Trains;
         Free_Seats : Integer;
         Seats : Integer;
         Destination : String_Ref_T);
      --  boards Passengers

      procedure Boarding
        (Train_Name : String_Ref_T;
         next_stage : Segment_T;
         Destination : String_Ref_T);
      --  Departs

      procedure Close_Doors
        (Train_Name : String_Ref_T;
         Free_Seats : out Integer;
         Destination : String_Ref_T);

      --  Passenger side

      --  the Passenger waits for the Train at the Platform
      entry Depart (Range_Trains)
        (Legs : Legs_Sequence_Ref_T;
         Travel_Index : Integer_Ref_T;
         Passenger_Name : String_Ref_T);
      --  once on board, it's enqueued at the arriving Station to exit

      entry Arrive (Range_Trains)
        (Legs : Legs_Sequence_Ref_T;
         Travel_Index : Integer_Ref_T;
         Passenger_Name : String_Ref_T);
      --  or to change Train..

      entry Change_Train (Range_Trains)
        (Legs : Legs_Sequence_Ref_T;
         Travel_Index : Integer_Ref_T;
         Passenger_Name : String_Ref_T);

   private

      Stopped_Train : String_Ref_T := null;
      Stopped_Train_Number : Range_Trains;
      TrainBoarding : String_Ref_T := null;
      next_stage_Train : Segment_T := null;
      tFree_Seats : Integer;
      tSeats : Integer;

   end Platform_T;

   type blg_T is array (Integer range <>) of Integer;

   --  a ticket daTabase for one Train
   protected type Ticket_DB_T
     (Train_Name : String_Ref_T;
      Train_Number : Range_Trains;
      Route : Path_Ref_T;
      Routefirst : Integer;
      Routelast : Integer;
      NumberofSeats : Integer) is

        --  books one leg on one Train
      entry Book_Leg
        (Legs : Legs_Sequence_Ref_T;
         Travel_Index : Integer_Ref_T;
         Passenger_Name : String_Ref_T);

        --  books one segment of the leg
      entry Book_Ticket (Routefirst..Routelast)
        (Legs : Legs_Sequence_Ref_T;
         Travel_Index : Integer_Ref_T;
         Passenger_Name : String_Ref_T);

      --  releases a ticket once is used
      procedure Release_Ticket
        (Legs : Legs_Sequence_Ref_T;
         Travel_Index : Integer_Ref_T;
         Passenger_Name : String_Ref_T);

   private

      Available_Tickets: blg_T (Routefirst..Routelast) :=
        (others => NumberofSeats);

   end Ticket_DB_T;

end Railway.Platform;
