--------------------------------------------------------
--  Copyright (C) 2006                                --
--  Alessandro Temil                                  --
--  Railway 1.0                                       --
--  Concurrent and Distributed Systems class project  --
--  Master Degree in Computer Science                 --
--  Academic year 2005/6                              --
--  Dept. of Pure and Applied Mathematics             --
--  University of Padua, Italy                        --
--                                                    --
--  This program is free software; you can            --
--  redistribute it and/or modify it under the terms  --
--  of the GNU General Public License as published    --
--  by the Free Software Foundation; either           --
--  version 2 of the License, or (at your option)     --
--  any later version.                                --
--------------------------------------------------------

with Distrailway.Central_Control;
with Ada.Text_IO;                 use Ada.Text_IO;

package body Railway.Ticket_Counter is

   protected body Ticket_Counter_T is

      entry Buy_Ticket
        (Legs : Legs_Sequence_Ref_T;
         Travel_Index : Integer_Ref_T;
         Passenger_Name : String_Ref_T) when True is

         Prefix : constant String := "is queuing at ";

         Index_First_Segment_leg : Integer;
         Index_Train_with_lower_Number : Integer := Legs'First;
         Legso_EC : Boolean := False;

      begin

         Passed := Clock - Start_Time;

         Distrailway.Central_Control.Upd_Passenger
           (Integer (To_Duration (Passed)),
            Passenger_Name.all,
            (Prefix & Name.all));

         for Legso_ix in Legs'First .. (Legs'Last - 1) loop

            if (Legs (Legso_ix).Train_Type = EC) then
               Legso_EC := True;
               if ((Legs (Legso_ix).Train_Number <
                      Legs (Index_Train_with_lower_Number).Train_Number)
                   or (Legso_ix = Legs'First))
               then
                  Index_Train_with_lower_Number := Legso_ix;
               end if;
            end if;

         end loop;

         --  starts booking the Train with the lowest Index

         if Legso_EC then

            Travel_Index.all := Index_Train_with_lower_Number;

            if Legs (Index_Train_with_lower_Number).Tickets = null then
               Put_Line ("ERROR - Ticket_Counter not specified");
            end if;

            requeue Legs (Index_Train_with_lower_Number).
              Tickets.Book_Leg;

         end if;

         Index_First_Segment_leg := Legs (Legs'First).Route'First;

         Passed := Clock - Start_Time;

         Distrailway.Central_Control.Upd_Passenger
           (Integer (To_Duration (Passed)),
            Passenger_Name.all,
            "is waiting for train " & Legs (Legs'First).Train_Name.all
            & " at platform "
            & Legs(Legs'First).
            Route(Index_First_Segment_leg).Departure_Platform.Name.all);

         requeue Legs (Legs'First).
           Route (Index_First_Segment_leg).
           Departure_Platform.Depart (Legs (Legs'First).Train_Number);

         --  the Passenger is enqueued on the Depart channel of the first leg

      end Buy_Ticket;

   end Ticket_Counter_T;

end Railway.Ticket_Counter;
