--------------------------------------------------------
--  Copyright (C) 2006                                --
--  Alessandro Temil                                  --
--  Railway 1.0                                       --
--  Concurrent and Distributed Systems class project  --
--  Master Degree in Computer Science                 --
--  Academic year 2005/6                              --
--  Dept. of Pure and Applied Mathematics             --
--  University of Padua, Italy                        --
--                                                    --
--  This program is free software; you can            --
--  redistribute it and/or modify it under the terms  --
--  of the GNU General Public License as published    --
--  by the Free Software Foundation; either           --
--  version 2 of the License, or (at your option)     --
--  any later version.                                --
--------------------------------------------------------

with Railway;          use Railway;
with Railway.Platform; use Railway.Platform;
with Ada.Real_Time;    use Ada.Real_Time;

--  there is a ticket counter for each Station
--  if a Route does not need booking, the ticket
--  is sold immediately. Otherwise, the booking
--  procedure is started

package Railway.Ticket_Counter is

   type Ticket_Counter_T;
   type Ticket_Counter_Ref_T is access all Ticket_Counter_T;

   type Route_T is record
      Legs : Legs_Sequence_Ref_T;
      Departure_Ticket_Counter : Ticket_Counter_Ref_T;
   end record;

   Passed : Time_Span;

   type Route_Ref_T is access all Route_T;

   protected type Ticket_Counter_T (Name : String_Ref_T) is

      entry Buy_Ticket
        (Legs : Legs_Sequence_Ref_T;
         Travel_Index : Integer_Ref_T;
         Passenger_Name : String_Ref_T);

   end Ticket_Counter_T;

end Railway.Ticket_Counter;
