--------------------------------------------------------
--  Copyright (C) 2006                                --
--  Alessandro Temil                                  --
--  Railway 1.0                                       --
--  Concurrent and Distributed Systems class project  --
--  Master Degree in Computer Science                 --
--  Academic year 2005/6                              --
--  Dept. of Pure and Applied Mathematics             --
--  University of Padua, Italy                        --
--                                                    --
--  This program is free software; you can            --
--  redistribute it and/or modify it under the terms  --
--  of the GNU General Public License as published    --
--  by the Free Software Foundation; either           --
--  version 2 of the License, or (at your option)     --
--  any later version.                                --
--------------------------------------------------------

with Distrailway.Central_Control;

package body Railway.Track is

   protected body Track_T is

      entry Enter (Train_Number : Integer;
                   Train_Name : access String;
                   Seats : Integer;
                   Seatsmax : Integer) when not In_Use is
      begin
         In_Use := True;
         Passed := Clock - Start_Time;
         Distrailway.Central_Control.Upd_Train
           (Integer (To_Duration (Passed)),
            Train_Number,
            Train_Name.all,
            Seatsmax-Seats,
            Seatsmax,"cruising on " & Name.all);
      end Enter;

      entry Leave (Train_Name : access String) when In_Use is
      begin
         In_Use := False;
      end Leave;

   end Track_T;

end Railway.Track;
