--------------------------------------------------------
--  Copyright (C) 2006                                --
--  Alessandro Temil                                  --
--  Railway 1.0                                       --
--  Concurrent and Distributed Systems class project  --
--  Master Degree in Computer Science                 --
--  Academic year 2005/6                              --
--  Dept. of Pure and Applied Mathematics             --
--  University of Padua, Italy                        --
--                                                    --
--  This program is free software; you can            --
--  redistribute it and/or modify it under the terms  --
--  of the GNU General Public License as published    --
--  by the Free Software Foundation; either           --
--  version 2 of the License, or (at your option)     --
--  any later version.                                --
--------------------------------------------------------

with Railway;       use Railway;

package Railway.Track is

   --  static variable used as the T0 reference basis for
   --+ the running counter of the elapsed time
   Passed : Time_Span;

   --  scale factor for calculation of the
   --  traversing time given line length
   Scaling_Factor : constant Positive := 5;

   protected type Track_T
     (Km   : Positive;
      Name : String_Ref_T) is

      --  get the track
      entry Enter (Train_Number : Integer;
                   Train_Name : access String;
                   Seats : Integer;
                   Seatsmax : Integer);

      --  release the track
      --+ (formal parameter not used explicitly
      --+  but needed for distributed dispatching)
      entry Leave (Train_Name : access String);

      private

         In_Use : Boolean := False;

   end Track_T;

   type Segment_T is access all Track_T;

end Railway.Track;
