--------------------------------------------------------
--  Copyright (C) 2006                                --
--  Alessandro Temil                                  --
--  Railway 1.0                                       --
--  Concurrent and Distributed Systems class project  --
--  Master Degree in Computer Science                 --
--  Academic year 2005/6                              --
--  Dept. of Pure and Applied Mathematics             --
--  University of Padua, Italy                        --
--                                                    --
--  This program is free software; you can            --
--  redistribute it and/or modify it under the terms  --
--  of the GNU General Public License as published    --
--  by the Free Software Foundation; either           --
--  version 2 of the License, or (at your option)     --
--  any later version.                                --
--------------------------------------------------------

with Railway.Track; use Railway.Track;

package body Railway.Train is

   task body Train_T is

      Current_Stage : Stage_T;
      Next_Stage : Stage_T;
      Arrival_Platform : Platform_Ref_T;
      Next_Destination : String_Ref_T;
      Traversing_Time : Time_Span;

      Index_Next_Stage : Integer;
      Index_Next_Next_Stage : Integer;

      Capacity : Integer := Seats;

   begin
      loop
         for Stage_Index in Route'Range loop
            Current_Stage := Route (Stage_Index);
            Traversing_Time :=
              Milliseconds (Current_Stage.Segment_Route.Km * Scaling_Factor);

            --  seizes the track
            Current_Stage.Segment_Route.Enter
              (Number, Name, Capacity, Seats);

            delay To_Duration (Traversing_Time);

            --  releases the track
            Current_Stage.Segment_Route.Leave (Name);

            if Stage_Index = Route'Last then
               Index_Next_Stage := Route'First;
            else
               Index_Next_Stage := Stage_Index + 1;
            end if;

            if Index_Next_Stage = Route'Last then
               Index_Next_Next_Stage := Route'First;
            else
               Index_Next_Next_Stage := Index_Next_Stage + 1;
            end if;

            Next_Stage := Route (Index_Next_Stage);
            Arrival_Platform := Next_Stage.Departure_Platform;
            Next_Destination := Route
              (Index_Next_Next_Stage).Departure_Platform.Station;

            --  arrives at the station and waits for the platform
            Arrival_Platform.Train_Arrived
              (Name, Number, Capacity, Seats, Next_Destination);

            delay To_Duration (Stop_Time);

            --  boards passengers
            Arrival_Platform.Boarding
              (Name, Next_Stage.Segment_Route, Next_Destination);

            delay To_Duration (Stop_Time);

            --  departs
            Arrival_Platform.Close_Doors (Name, Capacity, Next_Destination);

         end loop;

      end loop;

   end Train_T;

end Railway.Train;
