--------------------------------------------------------
--  Copyright (C) 2006                                --
--  Alessandro Temil                                  --
--  Railway 1.0                                       --
--  Concurrent and Distributed Systems class project  --
--  Master Degree in Computer Science                 --
--  Academic year 2005/6                              --
--  Dept. of Pure and Applied Mathematics             --
--  University of Padua, Italy                        --
--                                                    --
--  This program is free software; you can            --
--  redistribute it and/or modify it under the terms  --
--  of the GNU General Public License as published    --
--  by the Free Software Foundation; either           --
--  version 2 of the License, or (at your option)     --
--  any later version.                                --
--------------------------------------------------------

with Railway.Network;       use Railway.Network;
with Railway.Platform;      use Railway.Platform;
with Ada.Strings;           use Ada.Strings;
with Ada.Strings.Fixed;     use Ada.Strings.Fixed;
with Ada.Strings.Unbounded; use Ada.Strings.Unbounded;
with Ada.Text_IO;           use Ada.Text_IO;
with Ada.Exceptions;        use Ada.Exceptions;

package body Railway.Traveler is

   package body Passenger is

      AlName : aliased String := Name;

      function Map_Name (Station : Station_T) return String is
      begin
         for I in Stations_Map'Range loop
            if Stations_Map (I).Num = Station then
               return To_String (Stations_Map (I).Name);
            end if;
         end loop;
         return "";
      end Map_Name;

      task body Traveler_Task is

         Forward_Route, Backward_Route : Route_Ref_T;

         type Direction is (Forward, Backward);
         Toggle : Direction := Forward;

         procedure Make_Route
           (Legs : in Static_Route_T;
            Start_Ticket_Counter : Ticket_Counter_Ref_T;
            Route : out Route_Ref_T);

         procedure Make_Route
           (Legs : in Static_Route_T;
            Start_Ticket_Counter : Ticket_Counter_Ref_T;
            Route : out Route_Ref_T) is

            Leg_Array : Legs_Sequence_Ref_T;
            Leg_Ref : Leg_Ref_T;
            Tmp_Route : Route_Ref_T;
            First_Segment, Last_Segment: Integer;
            R_Last, R_Index : Integer;
            Invalid_Index : Integer;

         begin

            Leg_Array := new Legs_Sequence_T (Legs'First .. Legs'Last + 1);
            Leg_Array (Leg_Array'Last) := null;

            for I in Legs'Range loop
               Leg_Ref := new Leg_T;
               Leg_Ref.Train_Number := Legs (I).Train.Number;
               Leg_Ref.Train_Name := Legs (I).Train.Name;
               Leg_Ref.Train_Type := Legs (I).Train.category;
               Leg_Ref.Tickets := Legs (I).Train.ticket_DB;

               Invalid_Index := Legs (I).Train.Route'Last + 1;
               First_Segment := Invalid_Index;
               Last_Segment := Invalid_Index;

               for J in Legs (I).Train.Route'Range loop
                  if Index (Legs (I).Train.Route (J).Departure_Platform.Station.all,
                            Trim (Map_Name (Legs (I).From), Side => Both)) /= 0 then
                     First_Segment := J;
                     exit;
                  end if;
               end loop;

               for J in First_Segment .. Legs(I).Train.Route'Last loop
                  if Index (Legs (I).Train.Route (J).Departure_Platform.Station.all,
                            Trim (Map_Name (Legs(I).From), Side => Both)) /= 0 then
                     First_Segment := J;
                  end if;
                  if Index (Legs (I).Train.Route (J).Departure_Platform.Station.all,
                            Trim (Map_Name (Legs (I).To), Side => Both)) /= 0 then
                     Last_Segment := J;
                     exit;
                  end if;
               end loop;

               if Last_Segment =
                 Invalid_Index and
                 Index (Legs (I).Train.Route (Legs (I).Train.Route'First).Departure_Platform.Station.all,
                        Trim(Map_Name(Legs (I).To), Side => Both)) /= 0 then
                  Last_Segment := Legs (I).Train.Route'First;
               end if;

               if First_Segment = Invalid_Index or
                 Last_Segment = Invalid_Index then
                  Raise_Exception (Program_Error'Identity,
                                   "Fatal error: stage not found!");
                  if First_Segment = Invalid_Index then
                     Raise_Exception (Program_Error'Identity,
                                      "Fatal error: first segment not found!");
                  end if;
                  if Last_Segment = Invalid_Index then
                     Raise_Exception (Program_Error'Identity,
                                      "Fatal error: last segment not found!");
                  end if;
               end if;

               if First_Segment < Last_Segment then
                  Leg_Ref.Route := new Path_T (First_Segment .. Last_Segment);

                  for K in First_Segment .. Last_Segment loop
                     Leg_Ref.Route (K) := Legs (I).Train.Route (K);
                  end loop;

               else
                  R_Index := 1;
                  R_Last :=  Legs (I).Train.Route'Last - First_Segment + 1
                    + Last_Segment - Legs (I).Train.Route'First + 1;
                  Leg_Ref.Route := new Path_T (1 .. R_Last);

                  for K in First_Segment .. Legs (I).Train.Route'Last loop
                     Leg_Ref.Route (R_Index) := Legs (I).Train.Route (K);
                     R_Index := R_Index + 1;
                  end loop;

                  for K in Legs (I).Train.Route'First .. Last_Segment loop
                     Leg_Ref.Route (R_Index) := Legs (I).Train.Route (K);
                     R_Index := R_Index + 1;
                  end loop;

               end if;

               Leg_Array(I) := Leg_Ref;

            end loop;

            Tmp_Route := new Route_T;
            Tmp_Route.Legs := Leg_Array;
            Tmp_Route.Departure_Ticket_Counter := Start_Ticket_Counter;
            Route := Tmp_Route;

         end Make_Route;

         procedure Travel (Route : Route_Ref_T);

         procedure Travel (Route : Route_Ref_T) is
            Index_V : Railway.Integer_Ref_T;
         begin
            Index_V := new Integer;
            Index_V.all := Route.Legs'First;
            Route.Departure_Ticket_Counter.Buy_Ticket
              (Route.Legs, Index_V, AlName'Access);
         end Travel;

      begin

         Make_Route (Route_Forward, Ticket_Counter_Forward, Forward_Route);
         Make_Route (Route_Backward, Ticket_Counter_Backward, Backward_Route);

         loop

            case Toggle is
               when Forward =>
                  Travel (Forward_Route);
                  Toggle := Backward;
               when Backward =>
                  Travel (Backward_Route);
                  Toggle := Forward;
            end case;

            delay To_Duration (Milliseconds (Stationary_Period));

         end loop;
      exception
         when E: Program_Error =>
            Put_Line (Exception_Information (E));
         when A : others =>
            Put_Line (Exception_Name (A));
      end Traveler_Task;

   end Passenger;

end Railway.Traveler;
