--------------------------------------------------------
--  Copyright (C) 2006                                --
--  Alessandro Temil                                  --
--  Railway 1.0                                       --
--  Concurrent and Distributed Systems class project  --
--  Master Degree in Computer Science                 --
--  Academic year 2005/6                              --
--  Dept. of Pure and Applied Mathematics             --
--  University of Padua, Italy                        --
--                                                    --
--  This program is free software; you can            --
--  redistribute it and/or modify it under the terms  --
--  of the GNU General Public License as published    --
--  by the Free Software Foundation; either           --
--  version 2 of the License, or (at your option)     --
--  any later version.                                --
--------------------------------------------------------

with Railway.Train;          use Railway.Train;
with Railway.Ticket_Counter; use Railway.Ticket_Counter;

package Railway.Traveler is

   type Static_Leg_T is record
      Train : Train_Ref_T;
      From  : Station_T;
      To    : Station_T;
   end record;

   type Static_Route_T is array (Integer range <>) of Static_Leg_T;

   generic
      Name                    : String;
      Stationary_Period       : Positive;
      Ticket_Counter_Forward  : Ticket_Counter_Ref_T;
      Route_Forward           : Static_Route_T;
      Ticket_Counter_Backward : Ticket_Counter_Ref_T;
      Route_Backward          : Static_Route_T;
   package Passenger is

      task Traveler_Task;

   end Passenger;

end Railway.Traveler;
