--------------------------------------------------------
--  Copyright (C) 2006                                --
--  Alessandro Temil                                  --
--  Railway 1.0                                       --
--  Concurrent and Distributed Systems class project  --
--  Master Degree in Computer Science                 --
--  Academic year 2005/6                              --
--  Dept. of Pure and Applied Mathematics             --
--  University of Padua, Italy                        --
--                                                    --
--  This program is free software; you can            --
--  redistribute it and/or modify it under the terms  --
--  of the GNU General Public License as published    --
--  by the Free Software Foundation; either           --
--  version 2 of the License, or (at your option)     --
--  any later version.                                --
--------------------------------------------------------

with Railway.Network;  use Railway.Network;
with Railway.Traveler;

package Railway.Travelers is

   package Mickey_Mouse is new Railway.Traveler.Passenger
       (Name => "Mickey Mouse",
        Stationary_Period => 10,
        Ticket_Counter_Forward => Ticket_Counter_Bruxelles'Access,
        Route_Forward =>
          (1 => (Train => RT_BruxellesMadrid'Access,
                 From => Bruxelles,
                 To => Madrid)),
        Ticket_Counter_Backward => Ticket_Counter_Madrid'Access,
        Route_Backward =>
          (1 => (Train => RT_BruxellesMadrid'Access,
                 From => Madrid,
                 To => Bruxelles))
       );

   package Minnie_Mouse is new Railway.Traveler.Passenger
     (Name => "Minnie Mouse",
      Stationary_Period => 12,
      Ticket_Counter_Forward => Ticket_Counter_Wien'Access,
      Route_Forward =>
        (1 => (Train => RT_WienParis'Access,
               From => Wien,
               To => Paris),
         2 => (Train => RT_BruxellesMadrid'Access,
               From => Paris,
               To => Madrid)),
      Ticket_Counter_Backward => Ticket_Counter_Madrid'Access,
      Route_Backward =>
        (1 => (Train => RT_BruxellesMadrid'Access,
               From => Madrid,
               To => Bruxelles),
         2 => (Train => RT_WienParis'Access,
               From => Bruxelles,
               To => Wien))
     );

   package Goofy_Goose is new Railway.Traveler.Passenger
     (Name => "Goofy Goose",
      Stationary_Period => 14,
      Ticket_Counter_Forward => Ticket_Counter_Venezia'Access,
      Route_Forward =>
        (1 => (Train => EC_MadridVenezia'Access,
               From => Venezia,
               To => Paris)),
      Ticket_Counter_Backward => Ticket_Counter_Paris'Access,
      Route_Backward =>
        (1 => (Train => EC_MadridVenezia'Access,
               From => Paris,
               To => Venezia))
     );

   package Pluto_the_Pup is new Railway.Traveler.Passenger
     (Name => "Pluto the Pup",
      Stationary_Period => 16,
      Ticket_Counter_Forward => Ticket_Counter_Madrid'Access,
      Route_Forward =>
        (1 => (Train => EC_WienMadrid'Access,
               From => Madrid,
               To => Bruxelles)),
      Ticket_Counter_Backward => Ticket_Counter_Bruxelles'Access,
      Route_Backward =>
        (1 => (Train => RT_BruxellesMadrid'Access,
               From => Bruxelles,
               To => Madrid))
     );

   package Black_Pete is new Railway.Traveler.Passenger
       (Name => "Black Pete",
        Stationary_Period => 18,
        Ticket_Counter_Forward => Ticket_Counter_Bruxelles'Access,
        Route_Forward =>
          (1 => (Train => RT_BruxellesMadrid'Access,
                 From => Bruxelles,
                 To => Madrid)),
        Ticket_Counter_Backward => Ticket_Counter_Madrid'Access,
        Route_Backward =>
          (1 => (Train => RT_BruxellesMadrid'Access,
                 From => Madrid,
                 To => Bruxelles))
       );

   package Scrooge_McDuck is new Railway.Traveler.Passenger
     (Name => "Scrooge McDuck",
      Stationary_Period => 20,
      Ticket_Counter_Forward => Ticket_Counter_Wien'Access,
      Route_Forward =>
        (1 => (Train => RT_WienParis'Access,
               From => Wien,
               To => Bruxelles),
         2 => (Train => RT_BruxellesMadrid'Access,
               From => Bruxelles,
               To => Madrid)),
      Ticket_Counter_Backward => Ticket_Counter_Madrid'Access,
      Route_Backward =>
        (1 => (Train => RT_BruxellesMadrid'Access,
               From => Madrid,
               To => Bruxelles),
         2 => (Train => RT_WienParis'Access,
               From => Bruxelles,
               To => Wien))
     );

   package Donald_Duck is new Railway.Traveler.Passenger
     (Name => "Donald Duck",
      Stationary_Period => 22,
      Ticket_Counter_Forward => Ticket_Counter_Bruxelles'Access,
      Route_Forward =>
        (1 => (Train => EC_BruxellesMadrid'Access,
               From => Bruxelles,
               To => Paris),
         2 => (Train => EC_MadridVenezia'Access,
               From => Paris,
               To => Venezia)),
      Ticket_Counter_Backward => Ticket_Counter_Venezia'Access,
      Route_Backward =>
        (1 => (Train => EC_MadridVenezia'Access,
               From => Venezia,
               To => Paris),
         2 => (Train => EC_BruxellesMadrid'Access,
               From => Paris,
               To => Bruxelles))
     );

   package Daisy_Duck is new Railway.Traveler.Passenger
     (Name => "Daisy Duck",
      Stationary_Period => 24,
      Ticket_Counter_Forward => Ticket_Counter_Paris'Access,
      Route_Forward =>
        (1 => (Train => EC_WienMadrid'Access,
               From => Paris,
               To => Madrid)),
      Ticket_Counter_Backward => Ticket_Counter_Madrid'Access,
      Route_Backward =>
        (1 => (Train => EC_WienMadrid'Access,
               From => Madrid,
               To => Paris))
     );

   package Gladstone_Gander is new Railway.Traveler.Passenger
     (Name => "Gladstone Gander",
      Stationary_Period => 26,
      Ticket_Counter_Forward => Ticket_Counter_Paris'Access,
      Route_Forward =>
        (1 => (Train => EC_WienMadrid'Access,
               From => Paris,
               To => Madrid)),
      Ticket_Counter_Backward => Ticket_Counter_Madrid'Access,
      Route_Backward =>
        (1 => (Train => EC_WienMadrid'Access,
               From => Madrid,
               To => Paris))
     );

   package Gyro_Gearloose is new Railway.Traveler.Passenger
     (Name => "Gyro Gearloose",
      Stationary_Period => 28,
      Ticket_Counter_Forward => Ticket_Counter_Venezia'Access,
      Route_Forward =>
        (1 => (Train => EC_MadridVenezia'Access,
               From => Venezia,
               To => Paris),
         2 => (Train => RT_BruxellesMadrid'Access,
               From => Paris,
               To => Bruxelles),
         3 => (Train => EC_WienMadrid'Access,
               From => Bruxelles,
               To => Wien)),
      Ticket_Counter_Backward => Ticket_Counter_Wien'Access,
      Route_Backward =>
        (1 => (Train => EC_WienMadrid'Access,
               From => Wien,
               To => Bruxelles),
         2 => (Train => RT_BruxellesMadrid'Access,
               From => Bruxelles,
               To => Paris),
         3 => (Train => EC_MadridVenezia'Access,
               From => Paris,
               To => Venezia))
     );

end Railway.Travelers;
