--------------------------------------------------------
--  Copyright (C) 2006                                --
--  Alessandro Temil                                  --
--  Railway 1.0                                       --
--  Concurrent and Distributed Systems class project  --
--  Master Degree in Computer Science                 --
--  Academic year 2005/6                              --
--  Dept. of Pure and Applied Mathematics             --
--  University of Padua, Italy                        --
--                                                    --
--  This program is free software; you can            --
--  redistribute it and/or modify it under the terms  --
--  of the GNU General Public License as published    --
--  by the Free Software Foundation; either           --
--  version 2 of the License, or (at your option)     --
--  any later version.                                --
--------------------------------------------------------

with System;
with Ada.Real_Time; use Ada.Real_Time;

package Railway is

   --+--------------------------
   --  THE GLOBAL TIME REFERENCE
   --+--------------------------

   Start_Time : Time := Clock;

   --+--------------------------

   type String_Ref_T is access all String;

   Priority_IR : constant System.Priority := System.Priority'Last - 2;
   Priority_EC : constant System.Priority := System.Priority'Last - 1;

   type Train_Type_T is (IR, EC);

   type Integer_Ref_T is access all Integer;

   Min_Train : constant Integer := 1;
   Max_Train : constant Integer := 100;

   subtype Range_Trains is Integer range Min_Train .. Max_Train;

   type Station_T is (Paris, Bruxelles, Wien, Madrid, Venezia);

   --  Station Names
   PARISSTNAME : aliased String := ("Paris Gare du Nord");
   BRUXELLESSTNAME : aliased String := ("Bruxelles Midi");
   WIENSTNAME : aliased String := ("Wien Hauptbahnhof");
   MADRIDSTNAME : aliased String := ("Madrid Atocha");
   VENEZIASTNAME : aliased String := ("Venezia Santa Lucia");

end Railway;
