with Ada.Text_IO; --  to access basic I/O functions ("printf")
with RCP.Control;
package body RCP.User is
   task body User_T is
      use Ada.Text_IO;
      use RCP.Control;
      --  all users will want the same type of item
      --  but in different quantities
      --  (note that the object components will take their default value
      --   unless overridden by the instantiation)
      My_Allocation : Resource_T;
   begin
      loop
         Put_Line ("User " & Positive'Image (Id) &
                   " is asking for" & Request_T'Image (Demand) &
                   " resources.");
         --+-----------------------------------------------------
         --  a user requests the allocation of "demand" resources
         Controller.Demand (My_Allocation, Demand);
         --+-----------------------------------------------------
         Put_Line ("User " & Positive'Image (Id) &
                   " has obtained " &
                   Request_T'Image (My_Allocation.Granted) &
                   " resources.");
         --+-----------------------------------------------------
         --  does some (fake) work once the request has been satisfied
         delay Duration (Interval);
         --  then returns all of the resources in its possession
         Controller.Release (My_Allocation);
         --+-----------------------------------------------------
         Put_Line ("User " & Positive'Image (Id) &
                   " has released " &
                   Request_T'Image (My_Allocation.Granted) &
                   " resources.");
         --  and finally happily rests a little while on a job well done
         delay Duration (Interval);
      end loop;
   end User_T;
end RCP.User;
