with Ada.Text_IO; --  basic I/O primitives
with Time_IO;     --  formatted i/O primitives
with Ada.Real_Time;

package body Railroad.Reporter is

   protected Printer is

      --  pragma Priority (...); --  default ceiling = System.Priority'Last
      procedure Print
        (Id    : Positive;
         From,
         To    : Address_T);

   end Printer;

   protected body Printer is

      procedure Print
        (Id    : Positive;
         From,
         To    : Address_T) is
         use Ada.Text_IO,
             Ada.Real_Time;
         Passed : Ada.Real_Time.Time_Span;

      begin

         --  we note the time elapsed so far
         Passed := Clock - Start_Time;
         Put (" ");
         Time_IO.Put (Railroad.Interval (To_Duration (Passed)));
         Put_Line ("                        |    "
                   & Positive'Image (Id)
                   & "    "
                   & String (Stops (From))
                   & " "
                   & String (Stops (To)));
      end Print;

   end Printer;

   procedure Report
     (Id    : Positive;
      From,
      To    : Address_T) is

   begin

      Printer.Print (Id, From, To);

   end Report;

end Railroad.Reporter;
