with Ada.Real_Time;

package Railroad is
   use Ada.Real_Time;

   --+-----------------
   --  THE RAILWAY LINE
   --+-----------------
   --  the stops the train makes on the circular line
   type Address_T is (Verona, Vicenza, Padova, Mestre, Venezia);
   --  and the corresponding equal-size strings for pretty-printing
   type Locations_T is array (1 .. 7) of Character;
   Stops : constant array (Address_T) of Locations_T :=
             (Verona  => "VERONA ",
              Vicenza => "VICENZA",
              Padova  => "PADOVA ",
              Mestre  => "MESTRE ",
              Venezia => "VENEZIA");

   --  the time cost of each leg on the ring line
   Travel_Times : constant array (Address_T) of Ada.Real_Time.Time_Span :=
     (Milliseconds (3_000),
      Milliseconds (7_000),
      Milliseconds (4_000),
      Milliseconds (2_000),
      Milliseconds (16_000));

   --+-----------------------------
   --  THE PASSENGERS
   --+-----------------------------

   --  the population of passengers
   Population : constant Positive := 8;
   subtype IDs is Positive range 1 .. Population;
   type Passengers_T is range 0 .. Population;

   --+-----------------------------
   --  THE TRAIN
   --+-----------------------------

   --  the train max capacity for correct visualisation of output
   Capacity : constant Passengers_T := 4;
   --  and an array type ranging the identities of the traveler population
   --  for reporting of passengers at each stop
   type Travel_Identities_T is array (1 .. Population) of Boolean;

   --  to determine the identities of current Travelers
   --  value "True" denotes that the corresponding traveler
   --  is currently aboard
   En_Route : Travel_Identities_T := (others => False);
   --  (this vector is the obvious place where we might stick
   --  the string name of each traveler, so that we could print it
   --  in the progress reports)

   --+--------------------------
   --  THE GLOBAL TIME REFERENCE
   --+--------------------------
   Start_Time : Time := Clock;

   subtype Interval is Integer range 0 .. 86_400;

end Railroad;
