package body Railroad.Station is

   ---------------------------------
   --  THE STATION CLASS
   ---------------------------------
   protected body Station_T is
      --  all Travelers queued on Alight at the Station where the Train
      --  has stopped are allowed to get off
      entry Alight
        (Destination : Address_T;
         Traveler       : Positive) when Trainstopped is
      begin
         --  for each alighting passenger the count of Travelers aboard
         --  decrements by 1
         Transported := Transported - 1;
         En_Route (Traveler) := False;
      end Alight;
      -----------
      --  calls to Transfer at one departing Station succed
      --  when the Train is ready to board Travelers at that Station
      entry Transfer
        (Destination : Address_T;
         Traveler    : Positive)
        when Trainboarding and then Transported < Capacity is
         --  TEMPORARY FIX  --
         --  There : access Station_T :=
         --    Railway (Destination)'Unrestricted_Access;
         --  *************  --
      begin
         --  transport can happen hence the count of traveling Travelers
         --  increases by 1
         Transported := Transported + 1;
         En_Route (Traveler) := True;
         --  and the Traveler is requeded on the destination Station
         --  requeue Railway (Destination).Alight;
         --  TEMPORARY FIX  --
         requeue Railway (Destination).Alight; --  There.Alight;
      end Transfer;
      -----------
      --  the Train calls at a Station declaring its current load and
      --  allowing the Travelers Transferd at their destination to disembark
      procedure Calling (P : Passengers_T) is
      begin
         Transported := P;
         Trainstopped := True;
      end Calling;
      -------------
      --  the Train calls Boarding to stop any new Traveler from
      --  arriving before even departing and then to allow Travelers
      --  departing from that Station to board the Train
      procedure Boarding is
      begin
         Trainstopped  := False;
         Trainboarding := True;
      end Boarding;
      -------------
      --  the Train calls Closedoors to update the count of
      --  traveling Travelers and to stop boarding new Travelers
      procedure Departing (P :    out Passengers_T) is
      begin
         P := Transported;
         Trainboarding := False;
      end Departing;
      ---------------
   end Station_T;

end Railroad.Station;
