package Railroad.Station is

   ---------------------------------
   --  THE STATION CLASS
   ---------------------------------
   protected type Station_T is
      --  travelers call Transfer when they get to the departure station
      entry Transfer (Destination : Address_T;
                      Traveler    : Positive);
      --  the train calls Stopping when it gets to the station
      procedure Calling (P : Passengers_T);
      --  the train calls Boarding when it is ready to board travelers
      procedure Boarding;
      --  the train calls Closedoors to board passengers at the station
      procedure Departing (P :    out Passengers_T);
      --  the station requeues passengers to their destination
      --  station if the train capacity is not exhausted
      -----------------------------------
      --  this entry should really be private
      --  but the access model of Ada 2012 forbids it
      entry Alight (Destination : Address_T;
                    Traveler    : Positive);
      --  the travelers being transported
   private
      Transported : Passengers_T := 0;
      --  train willing to board travelers
      Trainboarding : Boolean := False;
      --  train calling at a station
      Trainstopped  : Boolean := False;
   end Station_T;

   --+-----------------
   --  THE RAILWAY LINE
   --+-----------------
   --  a ring with one Station per stop
   Railway : array (Address_T) of Station_T;

end Railroad.Station;
