with Railroad;
with Railroad.Station;
with Railroad.Reporter;

package body Railroad.Traveler is

   ------------------------------
   --  THE TRAVELER PROCESS CLASS
   ------------------------------
   task body Traveler_T is
      Current_Home,
      Current_Away : Address_T;
      type Direction_T is (To, Back);
      --  to tell which way the Traveler travels
      Trip         : Direction_T := To;
      Wake_Up      : Ada.Real_Time.Time := Start_Time;
      ---------------------
      --  SERVICE UTILITIES
      ---------------------
      procedure To_Work;
      procedure Back_Home;
      ---------------------
      procedure To_Work is
      begin
         Trip := To;
         Current_Home := Home;
         Current_Away := Away;
      end To_Work;
      ---------------------
      procedure Back_Home is
      begin
         Trip := Back;
         Current_Home := Away;
         Current_Away := Home;
      end Back_Home;
      ---------------------

      use Railroad.Station,
          Railroad.Reporter,
          Ada.Real_Time;

   begin --  TRAVELER_T
      Current_Home := Home;
      Current_Away := Away;
      loop
         case Trip is
            when To =>
               --------------------------------
               --  the away leg
               --------------------------------
               Report (Id, Current_Home, Current_Away);
               --  notify the departure station that the traveler
               --  wants to go to a specific destination
               Railway (Current_Home).Transfer (Current_Away, Id);
               --  at this point the traveler has arrived at destination
               --  and prepares for return
               Back_Home;
            when Back =>
               ---------------------------
               --  the return leg
               ---------------------------
               Report (Id, Current_Home, Current_Away);
               --  notify the departure station that the traveler
               --  wants to go to a specific destination
               Railway (Current_Home).Transfer (Current_Away, Id);
               --  at this point the traveler has arrived at destination
               --  and prepares for the next journey
               To_Work;
         end case;
         --  the traveler stays some time at the current destination
         Wake_Up := Wake_Up + Milliseconds (Interval);
         delay until Wake_Up;
      end loop;
   end Traveler_T;

end Railroad.Traveler;
